 ; Ŀ
 ;   Btray - draw a length of cable tray.                                  
 ;   Copyright 1997, 2004, 2010 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Box - draw a box by dragging or by input height and width.            
 ; 
 (DEFUN BOX (/ aa cc bb dd htp widdp)
  (setq aa (getpoint "First corner:"))
  (if (setq cc (getcorner aa "\nOpposite corner or <Return> to specify: "))
      (progn
           (setq bb (cons (car cc) (cdr aa)))
           (setq dd (cons (car aa) (cdr cc)))
           (command "pline" aa bb cc dd "c"))
      (progn
           (if (or (= (type widd) 'INT) (= (type widd) 'REAL))
               (progn
                    (setq widdp (getdist aa (strcat "\nWidth <"
                                                    (rtos widd 2 2) ">: ")))
                    (if widdp (setq widd widdp)))
               (setq widd (getdist aa "\nWidth: ")))
           (if (and (/= (type ht) 'INT) (/= (type ht) 'REAL) widd)
               (setq ht widd))
           (setq htp (getdist aa (strcat "\nand height <"
                                         (rtos ht 2 2) ">: ")))
           (if htp (setq ht htp))
           (command "pline" aa (polar aa 0 widd)
                               (polar (polar aa 0 widd) (* pi 1.5) ht)
                               (polar aa (* pi 1.5) ht)
                               "c")))
 (princ))
 ; Ŀ
 ;   Box end.                                                              
 ; 

 ; Ŀ
 ;   Hatche - hatch the last entity.                                       
 ; 
 (DEFUN HATCHE (/)
  (setq hasc (* (misps) 20))
  (if (zerop hasc) (setq hasc 20))
  (command "hatch" "dots" hasc "0" "l" "")
;  (command "change" "l" "" "p" "col" "red" "")
 (princ))
 ; Ŀ
 ;   Hatche end.                                                           
 ; 

 ; Ŀ
 ;   Btray.                                                                
 ; 
 (DEFUN C:BTRAY ( / *error* blip clay)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Load Misps.lsp, which contains the subroutines for scaling            
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (DEFUN *error* (shk /)
   (if blip (setvar "blipmode" blip))
   (if clay (setvar "clayer" clay))
   (command "undo" "end")
   (if (/= shk "Function cancelled") (write-line shk))
  (princ))
 ; Ŀ
 ;   Reset a couple of ystem variables, make the tray layer.               
 ; 
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq clay (getvar "clayer"))
  (if (tblsearch "layer" "tray")
      (setvar "clayer" "tray")
      (command "layer" "m" "tray" "c" "2" "" ""))
 ; Ŀ
 ;   Go for it.                                                            
 ; 
  (box)
  (hatche)
  (*error* "")
 (princ))